class twitch_statsd_relay::install inherits twitch_statsd_relay {

  validate_array($statsd_nodes)
  validate_array($statsd_ports)

  user { 'statsd':
    ensure  => 'present',
    system  => true,
    gid     => $statsd_group,
    require => Group['statsd']
  }

  group { 'statsd':
    ensure => 'present',
    system => true
  }

  file { '/etc/statsd':
    ensure => directory
  }

  file { '/var/run/go-statsd-proxy':
    ensure  => directory,
    owner   => 'statsd',
    group   => 'statsd',
    mode    => '0755',
    require => User['statsd'],
  }

  # TODO: deploy instead
  package { 'go-statsd-proxy':
    ensure => latest
  }

  # file { ['/opt/statsd','/opt/statsd/pids','/opt/statsd/bin']:
  #   ensure => 'directory',
  #   owner  => 'statsd',
  #   group  => 'statsd',
  #   mode   => '0755',
  # }

  # file { '/opt/statsd/bin/go-statsd-proxy.sh':
  #   ensure  => 'present',
  #   owner   => 'statsd',
  #   group   => 'statsd',
  #   mode    => '0755',
  #   source  => 'puppet:///modules/twitch_graphite_relay/go-statsd-proxy.sh',
  #   require => [Package['go-statsd-proxy'], File['/opt/statsd/bin']]
  # }

}
