class twitch_statsd_relay::monitoring inherits twitch_statsd_relay {

  # Make sure the statsd proxy is running
  twitch_nagios::service {'go-statsd-proxy_proc':
    is_nrpe     => true,
    command     => 'check_procs -c 1:1 -C go-statsd-proxy',
    description => 'go-statsd-proxy process',
    use         => 'generic-systems-service',
  }

  # Graphite hostname is the fqdn with '.' swapped with '_'
  $graphite_hostname = regsubst($::fqdn, '\.', '_', 'G')
  # Check UDP Error rate
  twitch_nagios::service {'check_udp_errors':
    is_nrpe     => false,
    command     => "check_graphite_data!500!1000!graphite-monitor.internal.justin.tv!aws.prod.servers.${graphite_hostname}.udp.InErrors",
    description => 'UDP Error Rate',
    use         => 'generic-systems-service',
  }

}
