class twitch_statsite::config inherits twitch_statsite {

  file { "$config_path":
    ensure => 'directory',
  }

  # pidfile directory
  file { "/var/run/statsite":
    ensure  => 'directory',
    owner   => 'statsite',
    group   => 'statsite',
    mode    => '0755',
    require => User['statsite']
  }

  sysctl::value { 'net.core.rmem_max':
    value => "134217728",
  }

  sysctl::value { 'net.core.rmem_default':
    value => "134217728",
  }
}
