class twitch_statsite (
  $statsite_proc_count        = $twitch_statsite::params::statsite_proc_count,
  $version                    = $twitch_statsite::params::version,
  $install_path               = $twitch_statsite::params::install_path,
  $config_path                = $twitch_statsite::params::config_path,
  $bind_address               = $twitch_statsite::params::bind_address,
  $graphite_sink              = $twitch_statsite::params::graphite_sink,
  $graphite_port              = $twitch_statsite::params::graphite_port,
  $flush_interval             = $twitch_statsite::params::flush_interval,
  $timer_eps                  = $twitch_statsite::params::timer_eps,
  $set_eps                    = $twitch_statsite::params::set_eps,
  $stream_cmd                 = $twitch_statsite::params::stream_cmd,
  $global_prefix              = $twitch_statsite::params::global_prefix,
  $use_type_prefix            = $twitch_statsite::params::use_type_prefix,
  $counts_prefix              = $twitch_statsite::params::counts_prefix,
  $extended_counters          = $twitch_statsite::params::extended_counters,
  $extended_counters_include  = $twitch_statsite::params::extended_counters_include,
  $timers_include             = $twitch_statsite::params::timers_include,
  $quantiles                  = $twitch_statsite::params::quantiles,
  $start_port                 = $twitch_statsite::params::start_port,
  $port_increment             = $twitch_statsite::params::port_increment,
) inherits twitch_statsite::params {

  anchor { "twitch_statsite::start": } ->
  class { "twitch_statsite::install": } ->
  class { "twitch_statsite::config": } ->
  twitch_statsite::services { "statsite":
    num_processes => $statsite_proc_count
  } ->
  class { "twitch_statsite::monitoring": } ->
  anchor { "twitch_statsite::end": }
}
