class twitch_statsite::install inherits twitch_statsite {

  package { 'statsite':
    ensure => '0.7.1.1'
  }

  file { "${install_path}/bin/statsite.sh":
    ensure => "present",
    content => template("${module_name}/statsite.sh.erb"),
    mode   => "0755",
  }

  file { "${install_path}/bin/graphite_sink.py":
    ensure  => 'present',
    content => file("${module_name}/graphite.py"),
    mode    => '0755'
  }

  group { 'statsite':
    ensure => 'present',
    system => true,
  }
  user { 'statsite':
    ensure  => 'present',
    system  => true,
    gid     => 'statsite',
    require => Group['statsite']
  }

}
