class twitch_statsite::monitoring inherits twitch_statsite {
  # Check for statsite running the right number of instances
  twitch_nagios::service { 'statsite_procs':
    is_nrpe     => true,
    command     => "check_procs -c ${statsite_proc_count}:${statsite_proc_count} -C statsite",
    description => 'Statsite Process Count',
    use         => 'generic-systems-service',
  }

  $graphite_hostname = regsubst($::fqdn, '\.', '_', 'G')
  twitch_nagios::service { 'statsite_udp_error_rate':
    is_nrpe     => false,
    command     => "check_graphite_data!.05!.10!graphite-monitor.internal.justin.tv!divideSeries(aws.prod.servers.${graphite_hostname}.udp.InErrors, aws.prod.servers.${graphite_hostname}.udp.InDatagrams)",
    description => 'UDP Error Rate',
    use         => 'generic-systems-service',
  }
}
