class twitch_statsite::params {
  $version             = '0.7.1.1' # internal fork
  $statsite_proc_count = 8
  $install_path        = '/usr/local'
  $config_path         = '/etc/statsite'
  $bind_address        = '0.0.0.0'
  $graphite_sink       = 'graphite.internal.justin.tv'
  $graphite_port       = 2003

  # statsite config options
  $flush_interval = 10
  $timer_eps = '0.005'
  $set_eps = '0.02'
  $stream_cmd = "python /usr/local/bin/graphite_sink.py $graphite_sink $graphite_port ''"
  $global_prefix = "stats."
  $use_type_prefix = true
  $counts_prefix = "counters."
  $extended_counters = true
  $extended_counters_include = ["count","rate","sum"]
  $timers_include = ["count","mean","stdev","sum","lower","upper","rate","median"]
  $quantiles = ["0.5","0.9","0.99"]

  # Port logic when using multiple processes on a single host
  $start_port         = 8129
  $port_increment     = 2
}
