class twitch_sysctl::params {
  $net_ipv4_tcp_mtu_probing = 0
  $net_ipv4_tcp_abort_on_overflow = 0
  $net_ipv4_tcp_max_orphans = 8192
  $net_ipv4_tcp_max_syn_backlog = 128
  $net_ipv4_tcp_syncookies = 1
  $net_core_netdev_max_backlog = 30000

  $settings_hash = {
    'kernel.panic' => { "value" => 15 },  # Reboot on kernel panic (default => 0)
    'kernel.shmmax' => { "value" => 33554432 },
    'net.core.netdev_max_backlog' => { "value" => hiera('net_core_netdev_max_backlog') },
    'net.core.rmem_max' => { "value" => 16777216 },
    'net.core.somaxconn' => { "value" => 65535 },
    'net.core.wmem_max' => { "value" => 16777216 },
    'net.ipv4.conf.all.arp_announce' => { "value" => 2 },
    'net.ipv4.conf.all.arp_ignore' => { "value" => 1 },
    'net.ipv4.conf.lo.arp_announce' => { "value" => 2 },
    'net.ipv4.conf.lo.arp_ignore' => { "value" => 1 },
    'net.ipv4.ip_local_port_range' => { "value" => "13000\t65535" },
    'net.ipv4.ip_nonlocal_bind' => { "value" => 0 },
    'net.ipv4.tcp_fin_timeout' => { "value" => 3 },
    'net.ipv4.tcp_max_orphans' => { "value" => hiera('net_ipv4_tcp_max_orphans') },
    'net.ipv4.tcp_max_syn_backlog' => { "value" => hiera('net_ipv4_tcp_max_syn_backlog') },
    'net.ipv4.tcp_max_tw_buckets' => { "value" => 2097152 },
    'net.ipv4.tcp_no_metrics_save' => { "value" => 1 },
    'net.ipv4.tcp_orphan_retries' => { "value" => 1 },
    'net.ipv4.tcp_syn_retries' => { "value" => 2 },
    'net.ipv4.tcp_synack_retries' => { "value" => 2 },
    'net.ipv4.tcp_syncookies' => { "value" => hiera('net_ipv4_tcp_syncookies') },
    'net.ipv4.tcp_tw_recycle' => { "value" => 0 },
    'net.ipv4.tcp_tw_reuse' => { "value" => 1 },
    'net.ipv4.tcp_mtu_probing' => { "value" => hiera('net_ipv4_tcp_mtu_probing') },
    'net.ipv4.tcp_abort_on_overflow' => { "value" => hiera('net_ipv4_tcp_abort_on_overflow') },
    'net.ipv6.conf.all.accept_ra' => { "value" => 0 },
    'net.ipv6.conf.all.accept_redirects' => { "value" => 0 },
    'net.ipv6.conf.all.autoconf' => { "value" => 0 },
    'net.ipv6.conf.all.dad_transmits' => { "value" => 0 },
    'net.ipv6.conf.all.disable_ipv6' => { "value" => 1 },
    'net.ipv6.conf.all.forwarding' => { "value" => 0 },
    'net.ipv6.conf.all.router_solicitations' => { "value" => 0 },
    'net.ipv6.conf.default.disable_ipv6' => { "value" => 1 },
    'net.ipv6.conf.lo.disable_ipv6' => { "value" => 1 },
    'vm.swappiness' => { "value" => 0 }  # Reduce swappiness (default => 60)
  }
}
