class twitch_unbound::params {

  $role                        = undef
  $num_threads                 = 4

  $interface                   = ''

  $interface_automatic         = true
  $unbound_conf_dir            = '/etc/unbound'
  $unbound_confd_dir           = "${unbound_conf_dir}/unbound.conf.d"
  $unbound_key_dir             = "${unbound_conf_dir}/keys.d"

  $route53_upstream            = [ '10.192.64.2' ]

  $twitch_networks             = hiera('twitch_networks')
  $access_cidrs                = [ '127.0.0.0/8' ]
  $allow_twitch_networks       = false
  $statistics_interval         = 0

  $default_custom_server_conf  = [ 'so-sndbuf: 16m', 'rrset-roundrobin: yes']
  $extra_custom_server_conf    = hiera_array(twitch_unbound::extra_custom_server_conf, [])
  $custom_server_conf          = concat ($default_custom_server_conf,$extra_custom_server_conf)
  $val_permissive_mode         = false
  $val_log_level               = 0

}
