# Wrapper for the OSS virtualbox module
class twitch_virtualbox {
  # The virtualbox uses the `apt` module to configure the upstream repo
  # We need to do it ourselves to avoid conflicts
  apt::source { "virtualbox":
    architecture      => "amd64",
    include_src       => false,
    key               => "7B0FAB3A13B907435925D9C954422A4B98AB5139",
    key_source        => "https://www.virtualbox.org/download/oracle_vbox.asc",
    location          => "http://download.virtualbox.org/virtualbox/debian",
    release           => "${::lsbdistcodename}",
    repos             => "contrib",
    required_packages => "debian-keyring debian-archive-keyring",
  }

  # Now we can get Virtualbox!
  class { "::virtualbox":
    manage_repo => false,
    require     => Apt::Source["virtualbox"],
  }
}
