require 'spec_helper'

describe 'virtualbox::extpack' do
  let(:title) { 'Oracle_VM_VirtualBox_Extension_Pack' }
  let(:pre_condition) { 'include virtualbox' }
  let(:facts) {{
    :osfamily => 'RedHat',
    :operatingsystem => "RedHat",
    :operatingsystemrelease => '6.5',
    :path => '/sbin:/bin',
  }}

  sane_defaults = {
    :ensure           => 'present',
    :source           => 'http://server.example.com/extpack.vbox-extpack',
    :checksum_string  => 'd41d8cd98f00b204e9800998ecf8427e',
  }

  context 'with defaults' do
    let(:params) {sane_defaults}

    it { should compile.with_all_deps }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_checksum(true) }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_digest_string('d41d8cd98f00b204e9800998ecf8427e') }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_digest_type('md5') }
    it { should contain_exec('Oracle_VM_VirtualBox_Extension_Pack unpack').with_creates('/usr/lib/virtualbox/ExtensionPacks/Oracle_VM_VirtualBox_Extension_Pack') }
    it { should contain_exec('Oracle_VM_VirtualBox_Extension_Pack unpack').that_requires('Archive::Download[Oracle_VM_VirtualBox_Extension_Pack.tgz]') }

  end

  context 'with ensure => absent' do
    let(:params) {sane_defaults.merge({:ensure => 'absent'})}
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_ensure('absent') }
    it { should contain_file('/usr/lib/virtualbox/ExtensionPacks/Oracle_VM_VirtualBox_Extension_Pack').with_ensure('absent') }
  end

  context 'with $verify_checksum => false' do
    let(:params) {sane_defaults.merge({
      :verify_checksum  => false,
      :checksum_type    => 'sha1',
    })}

    it { should compile.with_all_deps }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_checksum(false) }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_digest_string(nil) }
    it { should contain_archive__download('Oracle_VM_VirtualBox_Extension_Pack.tgz').with_digest_type('md5') }
    it { should contain_exec('Oracle_VM_VirtualBox_Extension_Pack unpack').with_creates('/usr/lib/virtualbox/ExtensionPacks/Oracle_VM_VirtualBox_Extension_Pack') }
  end
  
  context 'with bad checksum type' do
    let(:params) {sane_defaults.merge({ :checksum_type => 'invalid'})}

    it { expect { should contain_archive('Oracle_VM_VirtualBox_Extension_Pack') }.to raise_error(Puppet::Error, /does not match/) }
  end
end
