#!/bin/bash

# bootstrap_client.sh
# Mostly used to prepare Amazon Machine Images (AMIs)
ROLE=$1
ENVIRONMENT=$2

# Check privileges
if [ $(id -u) != 0 ]; then
  echo "Requires root access. Exiting."
  exit 1
fi

# For bare metal, we need to include any proxy configuration
test -f /etc/profile.d/proxy.sh && {
  echo "Including /etc/profile.d/proxy.sh"
  source /etc/profile.d/proxy.sh
}

# Install Puppet Labs apt repo and Puppet
# bootstrap_puppet.sh is in the same directory as this file
bash bootstrap_puppet.sh

# Classify the node
mkdir -p /etc/facter/facts.d
echo "twitch_role=${ROLE}" > /etc/facter/facts.d/twitch_role.txt
echo "twitch_environment=${ENVIRONMENT}" > /etc/facter/facts.d/twitch_environment.txt

# Run puppet
puppet agent --test --server=puppet.prod.us-west2.justin.tv --waitforcert 30
