#!/bin/bash

# bootstrap_master.sh
# Prepares a vanilla system to become a Twitch Puppet master

# Check privileges
if [ $(id -u) != 0 ]; then
  echo "Requires root access. Exiting."
  exit 1
fi

# For bare metal, we need to include any proxy configuration
test -f /etc/profile.d/proxy.sh && {
  echo "Including /etc/profile.d/proxy.sh"
  source /etc/profile.d/proxy.sh
}

# Install Puppet Labs apt repo and Puppet
# bootstrap_puppet.sh is in the same directory as this file
bash bootstrap_puppet.sh

# Install git
apt-get -qqy install git

# Clone our Puppet git repo
# To Do: skip some steps here and clone directly to /etc/puppet?
git clone https://git-aws.internal.justin.tv/will.roberts/puppet /tmp/puppet

# make sure hiera.yaml uses the temporary bootstrap path for hiera
sed -i 's/\/etc\/puppet\/environments\/%{environment}\/hiera/\/tmp\/puppet\/hiera/' /tmp/puppet/hiera.yaml

# Classify the node
mkdir -p /etc/facter/facts.d
echo 'twitch_environment=production' > /etc/facter/facts.d/twitch_environment.txt
echo 'twitch_role=puppet_master' > /etc/facter/facts.d/twitch_role.txt

# Make sure hostname, dns records, and dns_alt_names are set correctly
# To Do: automate this ^

# Run puppet apply on site.pp:
puppet apply --hiera_config=hiera.yaml --modulepath=modules manifests/site.pp

# Put our code into place
cp -a /tmp/puppet/* /etc/puppet/
