#!/bin/bash

# bootstrap_puppet.sh
# Configures the Puppet Labs apt repo and installs Puppet

PUPPET_VERSION="3.8.6-1puppetlabs1"

# Check privileges
if [ $(id -u) != 0 ]; then
  echo "Requires root access. Exiting."
  exit 1
fi

# Ensure /etc/facter/facts.d exists
echo "Creating /etc/facter/facts.d/..."
mkdir -p /etc/facter/facts.d

# We need to detect whether or not we're running inside the Twitch network and
# don't have NAT. If we can't reach Google, export the proxy environment vars.
echo "Attempting to reach the Internet..."
ping -c 4 www.google.com || {
  # Export our proxy environment variables
  echo "Unable to reach the Internet. Exporting proxy variables..."
  export http_proxy="http://proxy.internal.justin.tv:9797/"
  export no_proxy="localhost,127.0.0.1,127.0.1.1,127.0.0.0/8,199.9.248.0/21,192.16.64.0/21,10.0.0.0/8,.internal.justin.tv,.internal.twitch.tv,.justin.tv,.twitch.tv,.jtvnw.net"
  export HTTP_PROXY=$http_proxy
  export https_proxy=$http_proxy
  export HTTPS_PROXY=$http_proxy
  export NO_PROXY=$no_proxy

  # Keep track of the fact that we're operating without Internet access
  echo "has_nat=false" > /etc/facter/facts.d/has_nat.txt
}

# Configure Puppet Labs repository
apt-key list | grep -q 4BD6EC30 || {
  echo "Downloading Puppet Labs repository package..."
  wget -O /tmp/puppetlabs-release-precise.deb \
    https://apt.puppetlabs.com/puppetlabs-release-precise.deb || {
    echo "Failed to download Puppet Labs repository package"
    exit 1
  }
  echo "Configuring Puppet Labs repository..."
  dpkg -i /tmp/puppetlabs-release-precise.deb || {
    echo "Failed to install Puppet Labs repository package"
    exit 1
  }
}

# Install Puppet
dpkg -l puppet >/dev/null || {
  echo "Running apt-get update..."
  apt-get -qqy update >/dev/null
  echo "Installing Puppet..."
  apt-get -y install puppet=${PUPPET_VERSION} puppet-common=${PUPPET_VERSION}|| {
    echo "Failed to install Puppet"
    exit 1
  }
}
