#!/bin/sh
set -x
set -e

release=$(/usr/bin/lsb_release -cs)

# If using Precise, setup the repo before installing
if [ "$release" = "precise" ] ; then

  PUPPET_VERSION="3.8.6-1puppetlabs1"

  # Configure Puppet Labs repository
  apt-key list | grep -q 4BD6EC30 || {
    echo "Downloading Puppet Labs repository package..."
    wget -O /tmp/puppetlabs-release-precise.deb \
      https://apt.puppetlabs.com/puppetlabs-release-precise.deb || {
      echo "Failed to download Puppet Labs repository package"
      exit 1
    }
    echo "Configuring Puppet Labs repository..."
    dpkg -i /tmp/puppetlabs-release-precise.deb || {
      echo "Failed to install Puppet Labs repository package"
      exit 1
    }
  }

  # Install Puppet
  dpkg -l puppet >/dev/null || {
    echo "Running apt-get update..."
    apt-get -qqy update >/dev/null
    echo "Installing Puppet..."
    apt-get -y install puppet=${PUPPET_VERSION} puppet-common=${PUPPET_VERSION} || {
      echo "Failed to install Puppet"
      exit 1
    }
  }
# Xenial comes with Puppet ready to install, so just install it
elif [ "$release" = "xenial" ] ; then
  apt-get -y install puppet puppet-common || {
    echo "Failed to install Puppet"
    exit 1
  }
else
  echo "Unknown Ubuntu release: $release"
  exit 1
fi

# Remove some Vagrant bits
rm -rf /opt/vagrant_ruby
