#!/bin/sh
set -x
set -e

release=$(/usr/bin/lsb_release -cs)

# Misc setup work for Puppet
apt-get update && sudo apt-get install -y lvm2 python-boto
apt-get install -y openssl
apt-get install -y wget
rm -rf /etc/puppet/ssl /var/lib/puppet/ssl
sed -i '/certname/d' /etc/puppet/puppet.conf
# Xenial doesn't have this file
if [ "$release" != "xenial" ]; then
  sed -i 's/START=no/START=yes/' /etc/default/puppet
fi
sed -i 's/\(\[main\]\)/\1\nstringify_facts = false/' /etc/puppet/puppet.conf
sed -i 's/\(\[main\]\)/\1\ntrusted_node_data = true/' /etc/puppet/puppet.conf
#service puppet restart
puppet config print
mv /tmp/ebslvm.py /usr/sbin/ebslvm && sudo chown root.root /usr/sbin/ebslvm && sudo chmod 700 /usr/sbin/ebslvm
mv /tmp/run_ebslvm.upstart /etc/init/run_ebslvm.conf && sudo chown root.root /etc/init/run_ebslvm.conf && sudo chmod 700 /etc/init/run_ebslvm.conf
mkdir -p /etc/facter/facts.d/
