#!/usr/bin/env bash
set -euf -o pipefail -x

nonfmt="$(go fmt ./...)"
if [ -n "${nonfmt}" ]; then
	echo "${nonfmt}" | sed -e 's/^/non-gofmt code: /'
	false
fi

# -t: also check dependencies of test files
vendorcheck -t ./...

errcheck -ignoretests ./...

go vet ./...


