## TODOs - blocking on wider release

- Add version numbers to input file and output manifests.
- Add boilerplate-gen version and file checksums to manifest-file.

- Add .git-hooks from e.g. tenfoot and a mechanism for having users symlink them from .git/hooks.
  - Also allow project-wide or user-custom hooks.
  - Also support *setting up* user-custom hooks for the user?

- Refactor this repo
  - Re-enable golint in `.boilerplate.yaml` (for *this* repository).

- Write some docs.

- Need to sort out how we are encouraging the initial installation of `boilerplate-gen`.

- boilerplate-gen should break the project's build if re-running it would change any of the files it writes
  - we're also going to need an "allow changes to" list, then.


## TODOs - littler things I'd like done before wider release

- Look over `_examples/*.yaml`.

- Add a command that generates a default "minimal" configuration file.

- Store checksums in manifest; don't touch files that will not change; warn and require '-force' to overwrite files that
  have been manually modified.

- Support downloading and installing binary distributions of Go when we recognize them.
  (XXX: The documentation describes this feature and the configuration is present, though the feature isn't!)

- Issue WARNINGS if *any* "not suggested" configuration is present.
  (XXX: The documentation describes this feature, even though it hasn't been implemented!)

- Add '-verbose' flag that makes the tool print the names of the files it's generating.

## TODOs - bigger things

- Cache update checks.

- Deprecate install-tools.sh (and the tools that are installed elsewhere) in favor of retool!
  the tools that boilerplate-gen uses (linters, etc.) should be vendored using retool

- Test coverage.

- Deploy configuration for multiple artifacts/services/binaries from one repo.
  (At a minimum, we need to figure out what the format looks like.)

- Building/testing with multiple combinations of Go build tags.

## TODOs - little things

- Add automatically-generated-by warnings to the top of all files that will accept them.

- Automatically select the newest version of Go as the primary if one is not explicitly flagged.

- Add 'make primary' Makefile target.

- Add warning when newer versions of Go are available.

## TODOs - future/speculative

- Integrate 'common/meta/cmd/deps' somehow? (https:-git-aws.internal.justin.tv/common/meta/blob/master/cmd/dep/main.go)

## TODOs - unsorted

- Add a way to achieve the effect of `errcheck -ignoretests -ignore=EncodeVarint ./...`

- Have `courier.deploy_path` default to `/opt/twitch/<repo-name>` (e.g. `/opt/twitch/tenfoot`); some services deploy to
  `~jtv` instead, though, right?  Is it better to have this be explicit?

- Courier deploy script configuration?
  e.g. "no thanks, I've got my own deploy/restart scripts"
