package boilertpl

import (
	"html/template"
	"strings"
)

func mustMakeTemplate(name, data string) *template.Template {
	if len(funcMap) == 0 {
		panic("cannot build templates before initializing function map")
	}

	return template.Must(template.New(name).Funcs(funcMap).Parse(strings.TrimLeft(data, " \r\n\t")))
}

var (
	// N.B.: This needs to be done *before* we call mustMakeTemplate().
	funcMap = buildFuncMap()

	MantaJSON     = mustMakeTemplate(MantaJSONName, MantaJSONData)
	MantaMakefile = mustMakeTemplate(MantaMakefileName, MantaMakefileData)
	JenkinsGroovy = mustMakeTemplate(JenkinsGroovyName, JenkinsGroovyData)
	ScriptCI      = mustMakeTemplate(ScriptCIName, ScriptCIData)
	ScriptGo      = mustMakeTemplate(ScriptGoName, ScriptGoData)
	ScriptTools   = mustMakeTemplate(ScriptToolsName, ScriptToolsData)
	ScriptBuild   = mustMakeTemplate(ScriptBuildName, ScriptBuildData)
	ScriptLint    = mustMakeTemplate(ScriptLintName, ScriptLintData)
	ScriptTest    = mustMakeTemplate(ScriptTestName, ScriptTestData)
)
