package boilertpl

/*
manta_image: ubuntu:precise
manta_variant_name: go1.6.3

project_name: video/tenfoot
fq_project_name: code.justin.tv/video/tenfoot
go_version: 1.6.3

- add parameters for: build tags; GOEXPERIMENT; etc.
- move pprof to retool?
*/

const (
	// N.B.: There's no "path" here because we may create more than one of these files.
	MantaJSONName = "manta-json"
	// XXX: Is "GoVersion" correct there?
	// XXX: escape MantaFilePath
	MantaJSONData = `
{
    "image": "{{.Variant.MantaBaseImage}}",
    "mount": "/go/src/{{.Global.FQProjectName}}",
    "env": [],
    "setup_files": {
      "./.boilerplate/install-go.sh": "/tmp/build/install-go.sh",
      "./.boilerplate/install-tools.sh": "/tmp/build/install-tools.sh"
    },
    "setup": [
        "apt-get update && apt-get -y install build-essential wget git",
        "GOEXPERIMENT=framepointer /tmp/build/install-go.sh {{.Variant.Go.Version}}",
        "GOPATH=/go /tmp/build/install-tools.sh"
    ],
    "build": [
        "PATH=\"/go/bin:$PATH\" GOBIN=\"$PWD/.out/bin\" GOPATH=/go ./.boilerplate/ci.sh",
        "go build -a -tags 'netgo' -o .out/tool/pprof cmd/pprof"
    ],
    "extract": {
        "source": "/go/src/{{.Global.FQProjectName}}/.out",
        "destination": "{{.Variant.MantaOutputPath}}/"
    }
}
`

	/*
			   symbolic_names: go1.7 -> go1.7.1, go1.6 -> go1.6.3
			   manta_variants: ["go1.7.1", "go1.6.3"]
		       default_variant: go1.7  # one of the symbolic names
	*/
	MantaMakefileName = "makefile"
	MantaMakefilePath = "Makefile"
	MantaMakefileData = `
#
# This Makefile was automatically generated by boilerplate-gen; changes will NOT be preserved!
#
# You may set the MANTA_FLAGS variable to to pass arguments (e.g. "-v" for verbose output) to Manta.
#
# The lint, test, and build targets are shortcuts for running the corresponding part of what happens
# during the CI process in your local environment (i.e. outside of Manta).
#

all:{{range .Variants}} {{.BuildTargetName}}{{end}}

.PHONY: lint test build upgrade-boilerplate-gen

lint:
	.boilerplate/lint.sh

test:
	.boilerplate/test.sh

build:
	.boilerplate/build.sh

upgrade-boilerplate-gen:
	retool clean && retool upgrade code.justin.tv/kdkly/boilerplate-gen/cmd/boilerplate-gen origin/master && retool do boilerplate-gen
{{range .Variants}}
{{.BuildTargetName}}:{{range .BuildTargetDeps}} {{.}}{{end}}
	rm -rf "{{.MantaOutputPath}}" && manta -proxy -f "{{.MantaFilePath}}" $(MANTA_FLAGS)
{{end}}
`

	// XXX: Should escape the MantaFilePath.
	JenkinsGroovyName = "jenkins-groovy"
	JenkinsGroovyPath = "jenkins.groovy"
	JenkinsGroovyData = `
job {
	name "{{.Global.JenkinsBuildTestJobName}}"
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github '{{.Global.ProjectName}}', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'rm -rf .manta-output.d/'
{{- range .Variants}}
		shell 'manta -v -proxy -f {{.MantaFilePath}}'
{{- end}}
{{- if .Global.JenkinsSaveArtifact}}
		saveDeployArtifact '{{.Global.DeployArtifactName}}', '{{.Global.PrimaryVariant.MantaOutputPath}}'
{{- end}}
{{- if .Global.JenkinsSaveDirtyArtifact}}
		saveDirtyDeployArtifact '{{.Global.DeployArtifactName}}', '{{.Global.PrimaryVariant.MantaOutputPath}}'
{{- end}}
	}
}
{{if .Global.CourierEnabled}}
job {
	name '{{.Global.JenkinsDeployJobName}}'
	using 'TEMPLATE-deploy'
	steps {
		downloadDeployArtifact '{{.Global.DeployArtifactName}}'
		shell 'courier deploy --repo "{{.Global.ProjectName}}" --dir "{{.Global.CourierDeployPath}}" --short-circuit'
	}
}
{{end}}
`
)
