---
title: Developer Onboarding
description: "Onboarding Guide for Kerbin Developers"
date: 2020-05-01T08:33:08-07:00
weight: 2
---

### Prerequisite Setup
Please install all of the following to set up your developer environment

- [Homebrew](https://brew.sh/)

- [Amazon VPN](https://it.amazon.com/en/help/articles/registering-your-vpn-token) - Used to view internal Amazon resources and gain temporary permissions to shared AWS profiles.

- [Twitch VPN](https://wiki.twitch.com/display/HD/Twitch+VPN) - Most twitch internal services are gated by VPN usage. When trying to access a domain or run a service locally, please make sure you are on the Twitch VPN.

- [Golang](https://golang.org/dl/) - Most of the backend services here are written in Go. You can also install it with `brew install go`. Afterwards, add this line in your `.bashrc` or `.zshrc` if it's not in there already.
  ```
  export GOPATH=$HOME/go
  ```
This allows you to check out projects using `go get code.justin.tv/<owner>/<repo>` which will clone the project to `$GOPATH/src/code.justin.tv/<owner>/<repo>`.

- Git SSH
  - [Create SSH Key](https://help.github.com/en/github/authenticating-to-github/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent) (use `"<insert-your-username>@twitch.tv"` for email)
  - [Add SSH Pub-Key to GitHub](https://help.github.com/en/github/authenticating-to-github/adding-a-new-ssh-key-to-your-github-account)
  - [Set your username and email for Git](https://help.github.com/articles/setting-your-username-in-git/)

- AWS Profile
  - Work with another engineer to add you to get access to twitch-subs-aws, twitch-subs-dev AWS accounts
    - Steps to add new engineer: “Manage Accounts” -> “Console Access Roles” and add users. Disable password requirement for new user
  - Go to [Isengard](https://isengard.amazon.com/console-access). Follow the directions to set up your YubiKey.
  - Check to see that the two *-subs*- accounts are in your “AWS Console Access”
  - Set-up tools to refresh your Isengard temporary credentials for development and testing
    - [Automated script to refresh Isengard credentials](https://git-aws.internal.justin.tv/danielnf/isen)
    - Install Midway tool mwinit
    ```
      curl -O https://s3.amazonaws.com/com.amazon.aws.midway.software/mac/mwinit && chmod u+x mwinit && sudo mv mwinit /usr/local/bin/mwinit
    ```
    - [Download Tool-box](https://w.amazon.com/index.php/BuilderToolbox/GettingStarted)
    - [Instructions on installing Ada](https://docs.fulton.twitch.a2z.com/docs/mac_setup.html#ada)
    - Run Ada cmd (this will allow Isen-init script to run on Twitch VPN instead of Amazon VPN
    ```
    ada credentials update --account=958836777662 --provider=isengard --role=admin
    ```

- AWS CLI
  - Install AWS CLI
    ```
    brew install awscli
    ```
  - Configure the keys for AWS using the command line by following [these instructions](../aws-console). 
    

- JVM/JDK - Install it from the Self Service Application
- [Docker](https://docs.docker.com/docker-for-mac/install/)

### LDAP Membership
Access to our Git repositories is managed through LDAP and synched to Github Enterprise.  Request to be added to the following groups:
- team-subs
- team-revenue
- team-commerce
- teams-memberships

### Services
Here are some of the services that are commonly used or owned by our team.
- [Subscriptions](https://git-aws.internal.justin.tv/revenue/subscriptions) - Subscriptions Monolith Service

### Internal Tools
Here are some links to commonly used internal tools

- [Kerbin JIRA Board](https://jira.twitch.com/secure/RapidBoard.jspa?rapidView=523&projectKey=SUBS) - Track Sprint work