---
title: Terrarium 
description: "Operations info for Terrarium (CGREv2)"
---

## Quick Links

Terrarium is a set of step functions and python tasks that power the Community Gifting Recommendation Engine v2. 


| Links | Description |
|-------------|---------------------------------------------------------------|
| [Prod AWS account](https://isengard.amazon.com/federate?account=961173973684&role=admin) | Prod AWS console     |
| [Dev AWS account](https://isengard.amazon.com/federate?account=848870997264&role=admin) | Dev AWS console     |



## Debugging Oncall Pages

| Failure/Page | Failure Description | Remediation |
|--------------|-------------------- |-------------|
| Alarm: Twitch.Terrarium.us-west-2.CF-Parent Data Pipeline Alarm | The parent data pipeline failed to execute. This isn't a critical customer facing issue. | Investigate the ECS task logs for the failure.  |
| Alarm: Twitch.Terrarium.us-west-2.CF-GetGiftRecipientsv2 Alarm | The Clippy::GetGiftRecipientsV2 Lambda API is having problems. | Check the CGv2 Cloudwatch dashboard or the Lambda monitoring page. The Lambdas monitoring page will have "Recent Expensive" requests that may help in finding error logs. One common root cause for this alarm is the lambda failing to find suitable recipients before timing out. See [example ticket](https://t.corp.amazon.com/V185260815). |

## Tahoe Table Permissions
If in your investigation, you see an error like this:
`psycopg2.errors.InsufficientPrivilege: permission denied for schema tahoe_data`,
this means that the code lost permission to read from the tahoe table. 

When the Tahoe people have to manually re-create a table for some reason, we lose permission. 
They make sure that the reader roles get the new permissions, but they technically don’t support the case we have now, 
with a custom table permission set. Since Terrarium is likely going away once CGREv2.5 is completed, it’s easier to just
regenerate the permission to the new table. The larger fix would be removing the custom role, but from a security
standpoint having our role limited to just the schemas we needs seems better.

To fix the permissions, you need to get someone with access (currently only Avery) to run [this script][set-permissions-sql].    

[set-permissions-sql]: https://git-aws.internal.justin.tv/subs/terrarium/blob/master/queries/administration/set_permissions.sql
