create table analysis.kb_cheer_sim as (
with 

cdm as (
  select
    user_id,
    channel,
    sum(used_total) as mw
  from logs.bits_used_v2 
  where time >= sysdate - 30
  group by 1, 2
)

, mw_table as (
  select
    a.channel as channel,
    b.channel as competitor,
    sum(b.mw) as mw
  from cdm a
  left join cdm b
    on b.user_id = a.user_id
  group by 1, 2
)

, mw_totals as (
  select
    channel,
    mw
  from mw_table
  where channel = competitor
)

, agg as (
  select
    a.channel,
    a.competitor,
    a.mw as mw_a_to_b,
    b.mw as mw_b_to_a,
    c.mw as a_total_mw,
    d.mw as b_total_mw
  from mw_table a
  left join mw_table b
    on b.competitor = a.channel
    and b.channel = a.competitor
  left join mw_totals c
    on c.channel = a.channel
  left join mw_totals d
    on d.channel = a.competitor
)

, res as (
  select
    channel
    , competitor
    , (mw_a_to_b + mw_b_to_a) as intersect_value
    , (a_total_mw + b_total_mw) as union_value
    , (mw_a_to_b + mw_b_to_a)::float / (a_total_mw + b_total_mw) as jaccard_sim
  from agg
  where channel != competitor
)

, ccu_filter as (
  select
    channel
    , avg(total) as avg_ccu
  from logs.channel_concurrents 
  where time >= sysdate - 30
  group by 1
  having avg(total) >= 25
)

select
  a.channel as channel_a
  , a.competitor as channel_b
  , a.intersect_value
  , a.union_value
  , a.jaccard_sim
from res a
join ccu_filter b
  on a.channel = b.channel
join ccu_filter c
  on a.competitor = c.channel

);
