#!/usr/bin/python
import datetime
import os
import sys
import time

def hh_mm_ss_from_sec(seconds):
    return time.strftime('%H:%M:%S', time.gmtime(seconds))

def hh_mm_ss_from_ms(milliseconds):
    return time.strftime('%H:%M:%S', time.gmtime(float(milliseconds) / 1000.0))

def date_timestamp():
    return datetime.datetime.now().strftime("%Y-%m-%d")

def full_date_timestamp():
    return datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

def compute_seconds_from_hh_mm_ss(time_str):
    h, m, s = time_str.split(':')
    return int(h) * 3600 + int(m) * 60 + int(s)