package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"

	grafana "code.justin.tv/kevipike/graffiti"
)

type ServiceConfig struct {
	Org, Service, Environment, Region string
	CloudwatchDatasource              string
	BeanstalkEnvironmentName          string
	// servers.DiamondServers
	DiamondServers string
	// stats.counters.service.env.GolangHosts
	GolangHosts string
}

func main() {
	for _, config := range []ServiceConfig{
		{
			Org: "d8a", Service: "piper-service", Environment: "staging", Region: "us-west-2",
			BeanstalkEnvironmentName: "staging-d8a-piper-service-server",
			DiamondServers:           "piper-service-staging-ip-*",
			GolangHosts:              "ip-*",
		},
	} {

		var rows grafana.Marshallers

		rows = append(rows, &grafana.ServiceRequestsRow{
			Service: config.Service,
		})
		rows = append(rows, &grafana.ServiceGolangRow{
			Service: config.Service,
		})
		rows = append(rows, &grafana.ServiceInstanceRow{
			Servers: config.DiamondServers,
		})
		rows = append(rows, &grafana.ServiceHystrixRow{
			Service: config.Service,
		})

		dashboard := &grafana.ServiceDashboard{
			Org:         config.Org,
			Service:     config.Service,
			Environment: config.Environment,
			Hosts:       config.GolangHosts,
			Rows:        rows,
		}

		b, err := json.Marshal(dashboard)
		if err != nil {
			log.Fatal(err)
		}

		filename := fmt.Sprintf("%s-%s-%s.json", config.Org, config.Service, config.Environment)
		err = ioutil.WriteFile(filename, b, 0644)
		if err != nil {
			log.Fatal(err)
		}
	}

}
