package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"strings"

	grafana "code.justin.tv/kevipike/graffiti"
)

func main() {
	var hosts []string
	for i := 1; i < 10; i++ {
		for j := 1; j < 4; j++ {
			hosts = append(hosts, fmt.Sprintf("users-service-cache-000%d-00%d", i, j))
		}
	}

	datasource := "CloudWatch (twitch-web-aws)"

	metrics := []map[string]string{
		{
			"CacheHits": "Average",
		}, {
			"CacheMisses": "Average",
		}, {
			"CurrConnections": "Maximum",
		}, {
			"NewConnections": "Maximum",
		}, {
			"CPUUtilization": "Average",
		}, {
			"FreeableMemory": "Maximum",
		}, {
			"NetworkBytesIn": "Maximum",
		}, {
			"NetworkBytesOut": "Maximum",
		},
	}

	// Rows
	var rows grafana.Marshallers
	for _, metric := range metrics {
		// Panels
		var panels grafana.Marshallers

		for metricName, stat := range metric {
			// Targets
			var targets []interface{}
			for _, host := range hosts {
				targets = append(targets, grafana.CloudwatchTarget{
					Namespace: "AWS/ElastiCache",
					Dimensions: map[string]string{
						"CacheClusterId": host,
					},
					Region:     "us-west-2",
					Statistics: []string{stat},
					MetricName: metricName,
					Alias:      host,
				})
			}

			panels = append(panels, &grafana.Panel{
				Title:      strings.Join([]string{stat, metricName}, " "),
				Targets:    targets,
				Datasource: datasource,
			})
		}
		rows = append(rows, &grafana.Row{
			Title:  "",
			Panels: panels,
		})
	}

	dashboard := &grafana.Dashboard{
		Title: "users service elasticache aws",
		Rows:  rows,
	}

	b, err := json.Marshal(dashboard)
	if err != nil {
		log.Fatal(err)
	}

	err = ioutil.WriteFile("dashboard.json", b, 0644)
	if err != nil {
		log.Fatal(err)
	}
}
