package graffiti

import (
	"encoding/json"
	"strings"
)

type ServiceDashboard struct {
	Service     string
	Org         string
	Environment string
	Title       string
	Hosts       string
	Rows        interface{}
}

func (d ServiceDashboard) TemplateFile() string {
	return "./templates/dashboard-service.json"
}

func (d *ServiceDashboard) MarshalJSON() ([]byte, error) {
	if d.Title == "" {
		d.Title = strings.Join([]string{d.Org, d.Service, d.Environment}, " ")
	}

	return Template(d, func() error {
		b, err := json.Marshal(d.Rows)
		if err != nil {
			return err
		}
		d.Rows = string(b)
		return nil
	})
}

type ServiceRequestsRow struct {
	Service string
}

func (r ServiceRequestsRow) TemplateFile() string {
	return "./templates/row-service-requests.json"
}

func (r *ServiceRequestsRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}

type ServiceGolangRow struct {
	Service string
}

func (r ServiceGolangRow) TemplateFile() string {
	return "./templates/row-service-golang.json"
}

func (r *ServiceGolangRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}

type ServiceInstanceRow struct {
	Servers string
}

func (r ServiceInstanceRow) TemplateFile() string {
	return "./templates/row-service-instance.json"
}

func (r *ServiceInstanceRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}

type ServiceBeanstalkRow struct {
	Datasource      string
	Region          string
	EnvironmentName string
}

func (r ServiceBeanstalkRow) TemplateFile() string {
	return "./templates/row-service-beanstalk.json"
}

func (r *ServiceBeanstalkRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}

type ServiceChatRedisRow struct {
	Service string
	Title   string
}

func (r ServiceChatRedisRow) TemplateFile() string {
	return "./templates/row-service-chat-redis.json"
}

func (r *ServiceChatRedisRow) MarshalJSON() ([]byte, error) {
	if r.Title == "" {
		r.Title = "Redis"
	}
	return Template(r, nil)
}

type ServiceIdentityRediserRow struct {
	Service   string
	Namespace string
	Title     string
}

func (r ServiceIdentityRediserRow) TemplateFile() string {
	return "./templates/row-service-identity-rediser.json"
}

func (r *ServiceIdentityRediserRow) MarshalJSON() ([]byte, error) {
	if r.Title == "" {
		r.Title = "Redis"
	}
	return Template(r, nil)
}

type ServiceELBRow struct {
	Datasource       string
	Region           string
	LoadBalancerName string
}

func (r ServiceELBRow) TemplateFile() string {
	return "./templates/row-service-elb.json"
}

func (r *ServiceELBRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}

type ServiceHystrixRow struct {
	Service string
}

func (r ServiceHystrixRow) TemplateFile() string {
	return "./templates/row-service-hystrix.json"
}

func (r *ServiceHystrixRow) MarshalJSON() ([]byte, error) {
	return Template(r, nil)
}
