# puppet-to-ebextensions

This is a bit of code converts users-service puppet variables into elasticbeanstalk ebextensions

## Usage

1. Replace `params.pp` with your puppet modules params file
2. Replace `production` and `staging` with your puppet hiera/cluster files
3. Replace `defaults` and `modulePrefix` in `main.go` with your default configs and module name.
3. Run `go get . && go run main.go`
4. Profit with your new elasticbeanstalk `production.config` and `staging.config` files.

## Gotchas

Here are a few known gotchas and how to migitate them.

### `ERROR: Service:AmazonCloudFormation, Message:Template format error: Parameter 'EnvironmentVariables' default value '[****]' length is greater than 4096.`

Beanstalk concatenates all environment variables into a string that cannot exceed 4096 bytes. Try getting around by specifying your default environment variables in `defaults` to not write them. If you are still over, you need to reduce the environment variables you set. If your file is over 4096 bytes, the program will warn you.

```none
2017/07/18 11:50:58 WARNING: production is larger than 4096 bytes and won't work ( 4124 )
```
