job {
    name 'kevipike-spinnaker-test'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'kevipike/spinnaker-test', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell './scripts/build.sh'
        shell './scripts/push.sh'
    }
}



freeStyleJob('kevipike-spinnaker-test-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    scm {
        git {
            branches("*/master")
            remote {
                github 'kevipike/spinnaker-test', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }


    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-core-services-tcs-access-key'
            string 'AWS_SECRET_KEY', 'twitch-core-services-tcs-secret-key'
        }
    }

    steps {
      // setup properties file for use by spinnaker pipeline
      shell """
cat <<EOF>output.properties
GIT_COMMIT=\$GIT_COMMIT
GIT_BRANCH=\$GIT_BRANCH
GIT_AUTHOR_NAME=\$GIT_AUTHOR_NAME
GIT_AUTHOR_EMAIL=\$GIT_AUTHOR_EMAIL
BUILD_ID=\$BUILD_ID
JOB_NAME=\$JOB_NAME
EOF
"""
    }
    publishers {
      archiveArtifacts('output.properties')
    }
}


