
variable "oauth_token" {
  description = "The oauth/github personal access token to use"
}



provider "aws" {
  region     = "us-west-2"
  profile    = "twitch-core-services"
}

module "tf-spinnaker-hound-app-production-<no value>" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_spinnaker_hound_app?ref=0.1.0"
  aws_profile = "twitch-core-services"
  application_name = "production"
  oauth_token = "${var.oauth_token}"
  owner_name = "kevipike"
  owner_email = "devtools@twitch.tv"
  application_description = "A test application for testing dta/tf_spinnaker_hound_app terraform module"
  environment = "production"
  aws_account_names = "twitch-core-services"
  pipeline_jenkins_job = "kevipike-spinnaker-test-deploy"
  docker_image = "nginx"
  docker_ports = "8080/80"
  pipeline_notify_slack = "#dta-notications"
  deployment_key_pair_name = "devtools-dta"
  deployment_load_balancers = "prod.us-west2.justin.tv"
}

