package helpers

import (
	"fmt"
	"strings"
)

// GetClipSlugsFromURL splits up the relevant keys from a twitch clip URL
// i.e. https://twitch.tv/pajlada/KappaKeepo returns username pajlada and key KappaKeepo
func GetClipSlugsFromURL(clipURL string) (username, key string, err error) {
	parts := strings.Split(clipURL, "/")
	if len(parts) < 2 {
		return username, key, fmt.Errorf("Malformed clip URL")
	}

	username = parts[len(parts)-2]
	key = parts[len(parts)-1]
	return
}
