package main

import (
	"code.justin.tv/kkona/kkaper/apiclient"
	"code.justin.tv/kkona/kkaper/helpers"
	"code.justin.tv/kkona/kkaper/models"
)

func processPendingClip(clipURL string) error {
	username, key, err := helpers.GetClipSlugsFromURL(clipURL)
	if err != nil {
		return err
	}

	pClip := models.ProcessClip{}
	statusResponse := apiclient.TwitchClipStatus{}

	err = apiclient.GetClipData(username, key, &pClip.TwitchClip)
	if err != nil {
		return err
	}
	// Get clip data
	err = apiclient.GetClipStatus(username, key, &statusResponse)
	if err != nil {
		return err
	}

	pClip.MP4Path = statusResponse.QualityOptions[0].Source

	return models.AddProcessClip(&pClip)
}

func pollPendingClips(count int) error {
	pSuccess := 0
	pError := 0

	for i := 0; i < count; i++ {
		pendingClip, err := models.PopPendingClip()
		if err != nil {
			// I think this error is only thrown if the clip does not exist
			return err
		}

		if err := processPendingClip(pendingClip); err != nil {
			logger.Error(err)
			pError++
			continue
		}
		pSuccess++
	}

	if pSuccess > 0 || pError > 0 {
		logger.Debugf("Processed %d clips (%d failures)", pSuccess, pError)
	}

	return nil
}
