package main

import (
	"fmt"
	"sync"

	"code.justin.tv/kkona/kkaper/kkarrot/uploader"
	"code.justin.tv/kkona/kkaper/models"
	"code.justin.tv/kkona/kkaper/transcoder"
)

func pollToBeProcessedClips(count int) error {
	var wg sync.WaitGroup

	wg.Add(count)

	for i := 0; i < count; i++ {
		go func() {
			defer wg.Done()
			var clip models.ProcessClip
			if err := models.PopToBeProcessedClip(&clip); err != nil {
				logger.Error(err)
				return
			}

			clipID := fmt.Sprintf("%s-%s", clip.BroadcasterLogin, clip.Slug)

			localClipPath := fmt.Sprintf("clip-%s.mp4", clipID)

			// Start downloading and transcoding the clip
			clipJob := transcoder.ClipJob{
				ClipURL:        clip.MP4Path,
				OutputFileName: localClipPath,
			}
			if err := transcoder.StartJob(clipJob); err != nil {
				clip.NumRetries++
				models.AddProcessClip(&clip)
				logger.Error("Error processing transcoding job", err)
				return
			}

			// Start uploading the clip
			uploadJob := uploader.UploadJob{
				Key:      clipID + ".mp4",
				FilePath: localClipPath,
			}
			if err := uploader.StartJob(&uploadJob); err != nil {
				clip.NumRetries++
				models.AddProcessClip(&clip)
				logger.Error("Error when uploading clip", err)
				return
			}

			logger.Debugf("Finished processing %s - %s", clip.Slug, clip.ID)
		}()
	}

	wg.Wait()

	return nil
}
