package main

import "code.justin.tv/kkona/kkaper/apiclient"

func pollTrendingClips() error {
	// Poll twitch API for new clips
	newClips, err := apiclient.GetTrendingClips()
	if err != nil {
		return err
	}

	for _, clip := range newClips {
		logger.Debugf("Clip slug: %s", clip.Slug)
		mClip := apiClipToModelClip(clip)
		exists := mClip.Load()
		if !exists {
			// Start transcoding this clip
			// TODO: How do we get mp4 link from clip? it's not in the API
			err := mClip.Save()
			if err != nil {
				logger.Error("Error saving clip", err)
			}
		}
	}

	return nil
}
