package uploader

import (
	"bytes"
	"io/ioutil"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

var svc *s3.S3
var uploaderWorkers = make(chan bool, 5)

const uploadBucket = "mybucket"

// XXX: Should we specify the bucket here too?
type UploadJob struct {
	Key      string
	FilePath string
}

type UploaderSpecification struct {
	Cool string
}

func InitS3(s UploaderSpecification) error {
	sess, err := session.NewSession()
	if err != nil {
		return err
	}

	cred := credentials.NewEnvCredentials()
	cred.Get()

	awsConfig := aws.Config{
		Region:           aws.String("faux-region-1"),
		Endpoint:         aws.String("http://localhost:6062"),
		S3ForcePathStyle: aws.Bool(true),
		Credentials:      cred,
	}

	svc = s3.New(sess, &awsConfig)

	/*
			params := &s3.CreateBucketInput{
				Bucket: aws.String(uploadBucket),
			}

			logger.Debugf("Creating bucket...")

			createResp, err := svc.CreateBucket(params)
			if err != nil {
				return err
			}

		logger.Debugf("Got response: %#v", createResp)
	*/

	return nil
}

func StartJob(job *UploadJob) error {
	uploaderWorkers <- true

	return startUpload(job)
}

func startUpload(job *UploadJob) error {
	defer func() {
		<-uploaderWorkers
	}()

	fileBytes, err := ioutil.ReadFile(job.FilePath)
	if err != nil {
		return err
	}

	uploadParams := &s3.PutObjectInput{
		Bucket: aws.String(uploadBucket),
		Key:    aws.String(job.Key),
		Body:   bytes.NewReader(fileBytes),
	}

	_, err = svc.PutObject(uploadParams)
	if err != nil {
		return err
	}

	return nil
}

func UploadFile(path, key string) error {
	fileBytes, err := ioutil.ReadFile("test.png")
	if err != nil {
		return err
	}

	uploadParams := &s3.PutObjectInput{
		Bucket: aws.String(uploadBucket),
		Key:    aws.String("xDcoolkey"),
		Body:   bytes.NewReader(fileBytes),
	}

	_, err = svc.PutObject(uploadParams)
	if err != nil {
		return err
	}

	return nil
}
