package klogger

import (
	"os"

	logging "github.com/op/go-logging"
)

var (
	log    = logging.MustGetLogger("kkaper")
	format = logging.MustStringFormatter(
		`%{color}%{time:2006-01-02 15:04:05.000} %{shortpkg:-12s} %{shortfile:-19s} %{level:.4s}%{color:reset} %{message}`,
	)
)

// Init initialized the logging object
func Init() {
	backend1 := logging.NewLogBackend(os.Stdout, "", 0)
	backend2 := logging.NewLogBackend(os.Stdout, "", 0)
	backend2Formatter := logging.NewBackendFormatter(backend2, format)
	backend1Leveled := logging.AddModuleLevel(backend1)
	backend1Leveled.SetLevel(logging.ERROR, "")
	logging.SetBackend(backend1Leveled, backend2Formatter)
}

// GetLogger returns the shared logging object
func GetLogger() *logging.Logger {
	return log
}
