package main

import (
	"fmt"
	"testing"

	"code.justin.tv/kkona/kkaper/transcoder"
)

// TestTranscoder could fail if the connection to the twitch cdn fails for some reason
func TestTranscoder(t *testing.T) {
	tasks := []struct {
		ClipURL        string
		ExpectedResult bool
	}{
		{
			ClipURL:        "asd",
			ExpectedResult: false,
		},
		{
			ClipURL:        "https://clips-media-assets.twitch.tv/23650562128-offset-25740.mp4",
			ExpectedResult: true,
		},
	}
	for _, task := range tasks {
		clipJob := transcoder.ClipJob{
			ClipURL:        task.ClipURL,
			OutputFileName: "lol.mp4",
		}
		err := transcoder.StartJob(clipJob)
		if task.ExpectedResult {
			if err != nil {
				fmt.Printf("Error when expected result true: %s\n", err)
				t.Fail()
			}
		} else {
			if err == nil {
				fmt.Printf("Error: %s\n", err)
				t.Fail()
			}
		}
	}
}
