package models

import "github.com/garyburd/redigo/redis"

const pendingClipsKey = "kkarrot:clips:pending"

func AddPendingClip(clipURL string) (err error) {
	conn := db.Get()
	defer conn.Close()

	_, err = conn.Do("SADD", pendingClipsKey, clipURL)

	return
}

// XXX(pajlada): count argument is only available in redis-server >3.2, which is not available on ubuntu
func GetPendingClips(count int) (pendingClips []string, err error) {
	conn := db.Get()
	defer conn.Close()

	pendingClips, err = redis.Strings(conn.Do("SPOP", pendingClipsKey, count))

	return
}

func PopPendingClip() (string, error) {
	conn := db.Get()
	defer conn.Close()

	return redis.String(conn.Do("SPOP", pendingClipsKey))
}
