package models

import (
	"encoding/json"
	"io/ioutil"

	"github.com/garyburd/redigo/redis"
)

type Playlist struct {
	Bucket string  `json:"bucket"`
	Stacks []Stack `json:"stacks"`
}

const playlistsKey = "kkarrot:playlists"

func (p *Playlist) Save() (err error) {
	conn := db.Get()
	defer conn.Close()

	bytes, err := json.Marshal(p)
	if err != nil {
		return err
	}

	_, err = conn.Do("RPUSH", playlistsKey, bytes)
	return err
}

func CreatePlaylistFromFile(path string) (playlist Playlist, err error) {
	bytes, err := ioutil.ReadFile(path)
	if err != nil {
		return playlist, err
	}

	err = json.Unmarshal(bytes, &playlist)
	return playlist, err
}

func GetRandomPlaylist() (playlist Playlist, err error) {
	conn := db.Get()
	defer conn.Close()

	numElements, err := redis.Int(conn.Do("LLEN", playlistsKey))
	if err != nil {
		return playlist, err
	}

	randomIndex := numElements - 1

	bytes, err := redis.Bytes(conn.Do("LINDEX", playlistsKey, randomIndex))
	if err != nil {
		return playlist, err
	}

	err = json.Unmarshal(bytes, &playlist)
	return playlist, err
}
