package models

import (
	"encoding/json"

	"github.com/garyburd/redigo/redis"

	"code.justin.tv/kkona/kkaper/apiclient"
)

const processClipsKey = "kkarrot:clips:to_be_processed"

type ProcessClip struct {
	apiclient.TwitchClip

	NumRetries int
	MP4Path    string
}

func addProcessClipB(bytes []byte) error {
	conn := db.Get()
	defer conn.Close()

	_, err := conn.Do("RPUSH", processClipsKey, bytes)
	return err
}

func AddProcessClip(clip *ProcessClip) error {
	bytes, err := json.Marshal(clip)
	if err != nil {
		return err
	}

	return addProcessClipB(bytes)
}

func PopToBeProcessedClip(clip *ProcessClip) error {
	conn := db.Get()
	defer conn.Close()

	bytes, err := redis.Bytes(conn.Do("LPOP", processClipsKey))
	if err != nil {
		return err
	}

	if err := json.Unmarshal(bytes, clip); err != nil {
		logger.Error("Error unmarshalling process clip", err)
		return err
	}

	return nil
}

func GetToBeProcessedClips(count int) (clips []ProcessClip, err error) {
	conn := db.Get()
	defer conn.Close()

	byteSlices, err := redis.ByteSlices(conn.Do("LRANGE", processClipsKey, 0, count))
	if err != nil {
		return nil, err
	}

	clips = make([]ProcessClip, len(byteSlices))

	for _, bytes := range byteSlices {
		clip := ProcessClip{}

		if err := json.Unmarshal(bytes, &clip); err != nil {
			logger.Error("Error unmarshalling process clip", err)
			continue
		}

		clips = append(clips, clip)
	}

	return clips, nil
}
