package models

import (
	"time"

	"github.com/garyburd/redigo/redis"
)

type RedisSpecification struct {
	// Host of the redis server
	Host string `default:"localhost:6379"`

	// Which database to connect/select to
	Database int `default:"0"`

	// Maximum number of idle connections
	MaxIdle int `default:"69"`
}

var db *redis.Pool

func InitRedis(s RedisSpecification) {
	db = &redis.Pool{
		MaxIdle:     s.MaxIdle,
		IdleTimeout: 240 * time.Second,
		Dial: func() (redis.Conn, error) {
			conn, err := redis.Dial("tcp", s.Host)
			if err != nil {
				return nil, err
			}
			if s.Database > 0 {
				_, err = conn.Do("SELECT", s.Database)
				if err != nil {
					return nil, err
				}
			}
			return conn, err
		},
	}
}
