package models

import (
	"strings"

	"github.com/garyburd/redigo/redis"
	uuid "github.com/satori/go.uuid"
)

type Stack struct {
	UUID     string    `json:"uuid"`
	Elements []Element `json:"elements"`
	Duration float64   `json:"duration,omitempty"`
}

// TYPE: Hash
const stacksKey = "kkarrot:stacks"

// RemoveStacksUntilIID removes stacks up until given UUID
// XXX(pajlada): ask Love if we should remove all stacks if the UUID is not found
func RemoveStacksUntilUUID(untilUUID string) (count int, err error) {
	conn := db.Get()
	defer conn.Close()

	uuids, err := redis.Strings(conn.Do("HKEYS", stacksKey))
	if err != nil {
		return 0, err
	}

	uuidsToRemove := []string{}
	found := false

	for _, uuid := range uuids {
		if uuid == untilUUID {
			found = true
			break
		}

		uuidsToRemove = append(uuidsToRemove, uuid)
	}

	if found && len(uuidsToRemove) > 0 {
		count, err := redis.Int(conn.Do("HDEL", stacksKey, strings.Join(uuidsToRemove, " ")))
		return count, err
	}

	return 0, nil
}

// temporary method
func CreateStackFromClip(clip Clip) (stack Stack, err error) {
	stack.UUID = uuid.NewV4().String()
	stack.Elements = make([]Element, 2, 2)
	// TODO(pajlada): use bucket path here instead of slug
	stack.Elements[0] = Element{
		Type:  "video",
		Layer: "1-10",
		Path:  clip.Slug,
	}
	stack.Elements[1] = Element{
		Type:     "video",
		Layer:    "1-30",
		Path:     "assets/stinger.mov",
		InOffset: -1.3,
	}
	return stack, err
}

func CreateEndStack() (stack Stack, err error) {
	stack.UUID = uuid.NewV4().String()
	stack.Elements = make([]Element, 4, 4)
	stack.Elements[0] = Element{
		Type:  "video",
		Layer: "1-10",
		Path:  "assets/bgloop.mov",
	}
	stack.Elements[1] = Element{
		Type:  "video",
		Layer: "1-80",
		Path:  "assets/mangolife.wav",
	}
	stack.Elements[2] = Element{
		Type:      "video",
		Layer:     "1-12",
		Path:      "assets/clap-anim.mov",
		InOffset:  3,
		OutOffset: -1,
	}
	stack.Elements[3] = Element{
		Type:     "video",
		Layer:    "1-30",
		Path:     "assets/stinger.mov",
		InOffset: -1.3,
	}
	return stack, err
}
