package playlists

import (
	"code.justin.tv/kkona/kkaper/klogger"
	"code.justin.tv/kkona/kkaper/models"
	"github.com/gin-gonic/gin"
)

var logger = klogger.GetLogger()

type Stacks struct {
	InStack []string `json:"inStack"`
}

func postError(c *gin.Context, err error) {
	// in production we wouldn't want to spit out raw errors
	errorData := errorData{
		Code:    500,
		Message: err.Error(),
	}
	c.JSON(500, errorData)
}

func removeUntilStack(stacks Stacks) error {
	if stacks.InStack != nil && len(stacks.InStack) > 0 {
		// Got in stacks
		logger.Debugf("%#v", stacks.InStack)
		lastStackUUID := stacks.InStack[len(stacks.InStack)-1]
		count, err := models.RemoveStacksUntilUUID(lastStackUUID)
		if err != nil {
			return err
		}
		logger.Debugf("Removed %d stacks", count)
	}

	return nil
}
