package playlists

import (
	"math/rand"

	"code.justin.tv/kkona/kkaper/models"

	"github.com/gin-gonic/gin"
)

func getGenerate(c *gin.Context) {
	var json Stacks
	if c.Bind(&json) == nil {
		clips, err := models.GetAllClips()
		if err != nil {
			errorData := errorData{
				Code:    500,
				Message: err.Error(),
			}
			c.JSON(500, errorData)
			return
		}

		playlist := models.Playlist{}

		// XXX: hard coded for now
		playlist.Bucket = "s3://bestofclips-store"

		const numStacks = 4

		for i := 0; i < numStacks; i++ {
			randomClipIndex := rand.Intn(len(clips))
			// todo pop from index
			randomClip := clips[randomClipIndex]
			stack, err := models.CreateStackFromClip(randomClip)
			if err == nil {
				playlist.Stacks = append(playlist.Stacks, stack)
			}
		}

		if endStack, err := models.CreateEndStack(); err == nil {
			playlist.Stacks = append(playlist.Stacks, endStack)
		}

		c.JSON(200, playlist)
	}
}
