package playlists

import (
	"code.justin.tv/kkona/kkaper/models"

	"github.com/gin-gonic/gin"
)

func getRandom(c *gin.Context) {
	var stacks Stacks
	if err := c.Bind(&stacks); err == nil {
		if err := removeUntilStack(stacks); err != nil {
			postError(c, err)
		}
	}

	playlist, err := models.GetRandomPlaylist()
	if err != nil {
		errorData := errorData{
			Code:    500,
			Message: err.Error(),
		}
		c.JSON(500, errorData)
		return
	}
	c.JSON(200, playlist)
}
