package main

import (
	"flag"
	"fmt"

	"code.justin.tv/kkona/kkaper/klogger"
	"code.justin.tv/kkona/kkaper/models"
	"code.justin.tv/kkona/kkaper/web/api"
	"github.com/gin-gonic/contrib/static"
	"github.com/gin-gonic/gin"
	"github.com/pajlada/kkonfig"
)

// Specification Web
type Specification struct {
	Database models.RedisSpecification
}

var logger = klogger.GetLogger()

type stringSliceFlags []string

var configPaths stringSliceFlags

func (s *stringSliceFlags) String() string {
	return fmt.Sprint(*s)
}

func (s *stringSliceFlags) Set(value string) error {
	*s = append(*s, value)
	return nil
}

func init() {
	klogger.Init()

	flag.Var(&configPaths, "config", "Config path(s)")
	flag.Parse()

	var s Specification
	err := kkonfig.Process("web", configPaths, &s)
	if err != nil {
		logger.Error(err)
	}

	models.InitRedis(s.Database)
}

func main() {
	r := gin.Default()

	gAPI := r.Group("/api")
	api.New(gAPI)

	r.Use(static.Serve("/", static.LocalFile("public", true)))

	if err := r.Run(":42069"); err != nil {
		logger.Error(err)
	}
}
