var _ = require("lodash");

module.exports = function (_mainStack) {
    var _this = this;

    this.timer = null;
    this.startedTime = 0;
    this.mainStack = _mainStack;
    this.nextStack = null;
    this.totalTime = 0;

    this.markStartedTime = function () {
        if (this.startedTime == 0)
            this.startedTime = Date.now();
    }

    this.start = function () {
        this.markStartedTime();

        console.log("Start timer for", this.mainStack.uuid);
        this.timer = setInterval(function (_this) {
            // Calculate virtual play head and time left
            var playHead = Date.now() - _this.startedTime;
            var timeLeft = _this.totalTime - playHead;

            // Check if timer has finished
            if (timeLeft <= 0) {
                // If timer has overshot, set play head to end of stack
                playHead = _this.totalTime;

                // Kill the timer
                clearInterval(_this.timer);
            }

            // Call the time callback with out virtual times converted to seconds
            _this.mainStack.mainTimeCb(parseFloat(playHead) / 1000.0, parseFloat(_this.totalTime) / 1000.0)

            if (_this.nextStack) {
                _this.nextStack.nextTimeCb(parseFloat(playHead) / 1000.0, parseFloat(_this.totalTime) / 1000.0)
            }

            if (timeLeft <= 0) {
                _this.mainStack.popStack();
            }

        }, 10, this);
    }

    // Set a timer for a virtual playhead
    this.setTimer = function(time) {
        // Convert seconds to milliseconds
        if (!this.totalTime) {
            this.totalTime = parseInt(time * 1000);
        }
    }
}
