var _ = require("lodash");
var CasparCG = require("./caspar-cg");
var Timer = require("./caspar-timer.js");
var settings = require("./setting.json");

var activeLayers = {};

function Caspar (cb) {
    var playStackList = [];
    var ccg = new CasparCG(settings.casparIP, 5250);

    ccg.connect(function () {
        ccg.info(function (err, serverInfo) {
            console.log(serverInfo);
        });


        // Clear CasparCG output
        ccg.clear(1);

        // Send an callback to initiate first API fetch
        cb();
    });

    this.isInStack = function (uuid) {
        return (_.find(playStackList, {uuid: uuid}) != undefined);
    }

    this.getPlayStack = function () {
        return playStackList;
    }

    this.element = function (type, layer, localPath, inPoint, outPoint, options, data) {
        var _element = this;
        this.type = type;
        this.layer = layer;
        this.localPath = localPath;
        this.inPoint = inPoint;
        this.outPoint = outPoint;

        this.options = options;

        this.data = data;
        this.parent = null;

        this.hasTriggered = false;
        this.hasStopped = false;

        this.play = function () {
            if (!this.hasTriggered) {
                console.log("Element play", this.localPath);

                this.hasTriggered = true;
                activeLayers[this.layer] = this.parent.uuid;

                if (this.type == "template") {
                    ccg.loadTemplate(this.layer, this.localPath, true, data);
                } else {
                    if (_element.layer == "1-10") {
                        _element.parent.timer.markStartedTime();
                    }

                    ccg.play(this.layer, this.localPath, { }, function (err) {
                        if (!err && _element.layer == "1-10") {
                            setTimeout(function () {
                                ccg.info(_element.layer, function (err, data) {
                                    console.log(err,data);
                                    var fileLength = parseFloat(data.foreground.fileLength - data.foreground.currentFileFrame);
                                    var fps = parseFloat(data.foreground.fps);

                                    _element.parent.timer.setTimer(parseInt(fileLength / fps));

                                    _element.parent.timer.start();
                                });
                            }, 400);
                        }
                    });
                }
            }
        }

        this.stop = function () {
            if (this.hasTriggered && !this.hasStopped && activeLayers[this.layer] == this.parent.uuid) {
                console.log("Element stop", this.localPath);

                this.hasStopped = true;
                if (this.type == "template") {
                    ccg.stopTemplate(this.layer);
                } else {
                    ccg.stop(this.layer);
                }
            }
        }

        // Callback used to trigger elements with delayed start
        this.newTimeFromStart = function (time) {
            if (!this.hasTriggered && time >= this.inPoint)
            {
                console.log("From start trigger");
                this.play();
            }
        }

        // Callback used to trigger negative element end times
        this.newTimeFromEnd = function (time) {
            if (typeof this.outPoint !== 'boolean'
            && this.hasTriggered && !this.hasStopped
            && time <= (-this.outPoint))
            {
                console.log("End stop");
                this.stop();
            }
        }

        // Callback from previous clip stack for clips with negative start times
        this.newTimeFromEndLastClip = function (time) {
            if (!this.hasTriggered && this.inPoint <= 0 && time <= (0 - this.inPoint))
            {
                console.log("Pre trigger");
                this.play();
            }
        }
    }

    this.playStack = function (uuid) {
        this.stack = [];
        this.totalTime = 0;
        this.uuid = uuid;

        this.timer = new Timer(this);

        this.addElement = function (element) {
            element.parent = this;
            this.stack.push(element);
        }

        // Remove this stack from the playlist
        this.popStack = function () {
            _.remove(playStackList, function(n) {
                return n === _this;
            });
        }

        // Time "code" from this stacks timer
        this.mainTimeCb = function (playhead, length) {
            _.forEach(this.stack, function (e) {
                e.newTimeFromStart(playhead);
                e.newTimeFromEnd(length - playhead);
            });
        }

        // Time "code" from the previous stack in the playlist
        this.nextTimeCb = function (playhead, length) {
            _.forEach(this.stack, function (e) {
                e.newTimeFromEndLastClip(length - playhead);
            });
        }

        // Manual start of stack
        this.start = function () {
            // Tell all elements in stack that the stack has started
            _.forEach(this.stack, function (e) {
                e.newTimeFromStart(0);
            });

            if (!this.hasMainVideo()) {
                this.timer.start();
            }
        }

        this.hasMainVideo = function () {
            var hasVideo = false;

            _.forEach(this.stack, function (e) {
                if (e.layer == "1-10") {
                    hasVideo = true;
                }
            });

            return hasVideo;
        }
    }

    // Push a play stack to the playlist
    this.pushPlayStack = function(stack) {
        playStackList.push(stack);

        // If the playlist was empty, start the stack
        if (playStackList.length == 1) {
            playStackList[0].start();
        } else {
            playStackList[playStackList.length - 2].timer.nextStack = stack;
        }
    }


}


module.exports = function (cb) {
    return new Caspar(cb);
};
