var _ = require("lodash");
var cache = require("./cache.js");
var request = require("request")
var Caspar = require("./caspar.js");
var settings = require("./setting.json");

var caspar;


function casparCallback() {
    console.log("Stack completed callback");
    var stackList = caspar.getPlayStack();

    var uuidsInStack = [];
    _.forEach(stackList, function (o) {
        uuidsInStack.push(o.uuid);
    });

    request({
        url: settings.playlistURL,
        json: {inStack: uuidsInStack},
        method: "POST"
    }, function (error, response, body) {

        if (!error && response.statusCode === 200 && !caspar.isInStack(body.stacks[0].uuid)) {
            console.log(stackList);

            cache.waitForStacks(body.stacks, function () {
                _.forEach(body.stacks, function (o) {

                    var stack = new caspar.playStack(o.uuid);
                    if (o.duration) {
                        stack.timer.setTimer(o.duration);
                    }

                    _.forEach(o.elements, function (e) {

                        var cacheName = cache.peekFile(e.path, function () {});
                        console.log(cacheName);

                        stack.addElement(
                            new caspar.element(e.type, e.layer, cacheName, e.inOffset, e.outOffset, {}, {})
                        );
                    });

                    caspar.pushPlayStack(stack);
                });
                setTimeout(casparCallback, 5000);
            });
        } else {
            setTimeout(casparCallback, 5000);
        }
    });


    console.log(uuidsInStack);

}

function loadAssets() {
    request({
        url: settings.assetsURL,
        json: true
    }, function (error, response, body) {

        if (!error && response.statusCode === 200) {
            console.log(body) // Print the json response

            cache.waitForAssets(body.assets, function () {
                caspar = Caspar(casparCallback);
            });
        }
    });
}

//cache.touchFile("test/empty.mov");

loadAssets();
