# Vienna

Vienna is an internal staff-admin site to manage Community/Lifecycle products like
[RBAC](https://git-aws.internal.justin.tv/lifecycle/devsite-rbac).

Environments:

- Production: https://vienna.xarth.tv
- Staging: https://vienna-dev.xarth.tv

NOTE: The previous Vienna site was: https://git.xarth.tv/devrel/vienna

This repository contains the single-page-app frontend, the Go edge backend and the CDK
infrastructure definitions.

## OnCall Runbook

See [RUNBOOK.md]

## Vienna Single-Page-App Frontend

The frontend is a TypeScript application.

Development commands:

- Use [nvm](https://github.com/nvm-sh/nvm) to install and run Node with the version specified in the
  `.nvmrc` file.
- `npm install`: install dependencies (need to be on Twitch-VPN)
- `yarn dev:staging`: (`yarn dev` for short) run frontend against the staging edge backend.
- `yarn dev:prod`: run frontend in dev-mode in localhost, using the production edge backend.
- `yarn dev:local`: run frontend against a local edge backend.
- See `package.json` "scripts" section for more

## Vienna Edge Backend

The backend is a Go service that runs in the same domain as the single-page-app frontend. It is a
static site web server, and a reverse proxy to redirect requests to other services using
private-links in the same VPC network.

Development commands:

- `make run` to start a local service
- `make test` to run unit tests.
- See `Makefile` for more.

## Adding a Client to a downstream service

Vienna can make GraphQL queries and mutations, but sometimes it needs to send requests directly to
downstream services, after all, it is an admin interface to do staff-only operations. The request
flow:

```
Vienna Frontend (request authenticated with Bouncer)
    => Vienna Edge Backend (may use a reverse-proxy rule for simplicity)
        => Downstream Service (through a private-link or AWS access policy)
```

It possible to define new routes in the Edge Backend, to handle any new arbitrary requests. But the
preferred method is to define a reverse proxy rule on the edge, and just re-send the frontend
requests to their backends.

- Add a routing rule to the mux in `api/api.go`, using a reverse proxy to Twirp HTTP or Twirp
  Lambda.
- Allow the Vienna AWS account to contact their service with a private-link in cdk-infra, or any
  other method. They need to allow access from the Vienna account on their side.

On the frontend, it is possible to send any arbitrary JSON request to the edge. But the preferred
method is to generate a TypeScrit client for their Twirp service. Together with the reverse proxy
rule in the edge, it will look like talking to their service directly.

- Add a folder on `/src/core/clients` for their service client.
- Copy-paste their proto file definition. Edit the file to add a comment to the repository with the
  exact version.
- Use the TypeScript generator: `cd` into the folder and run
  `protoc --proto_path=. --twirp_ts_out=. ./*.proto`
- Edit the generated files to fix syntax issues (e.g. remove invalid prefixes).
- Example PR: https://git.xarth.tv/lifecycle/Vienna/pull/14

## Deploy

The full-stack is build into a single Docker image, that is deployed to ECS. The Go app is compiled
into a single binary. The frontend app is packed into static assets in the `dist` folder, that is
served from the Go app.

- `make deploy_dev`: builds docker image, pushes it to ECR and then starts a rolling deploy on ECS.

## Vienna CDK Infra

Infra is defined in the `/cdk-infra` folder. See [./cdk-infra/README.md] for more info.
